rm(list=objects())
setwd("~/Desktop/Experiments/Simulations/Results")

type <- 2
path <- "Missing Observations"
K <- 3
M <- 100 # number of experiments############a
N <- 500
p_list <- rep(0,14)

# record the errors
Error_missSBM <- matrix(NA, ncol = 3, nrow = 14)
Error_Var <- matrix(NA, ncol = 3, nrow = 14)
Error_true_Z <- matrix(NA, ncol = 3, nrow = 14)
Error_softImpute <- matrix(NA, ncol = 3, nrow = 14)
Error_av <- matrix(NA, ncol = 3, nrow = 14)

for (n in 1:14){
  res <- readRDS(paste0(path, "/r_", n,"_av.RDS"))
  p_list[n] <- res$p
  Error_missSBM[n,] <- quantile(res$Error_missSBM, probs = c(0.25, 0.5, 0.75))
  
  Error_Var[n,] <- quantile(res$Error_Var, probs = c(0.25, 0.5, 0.75))
  
  Error_softImpute[n,] <- quantile(res$Error_softImpute, probs = c(0.25, 0.5, 0.75))
  
  Error_true_Z[n,] <- quantile(res$Error_true_Z, probs = c(0.25, 0.5, 0.75))
  
  Error_av[n,] <- quantile(res$Error_av, probs = c(0.25, 0.5, 0.75))
}

#Error_softImpute <- log(Error_softImpute)
#Error_true_Z <- log(Error_true_Z)
#Error_Var <- log(Error_Var)
#Error_missSBM <- log(Error_missSBM)

plot(x = p_list, y = Error_softImpute[,2], type = 'l', col = 'green',
     xlab = "", ylab = "", log = "x", ylim = c(0.019, 0.021), xlim = c(0.05, 1))
lines(x = p_list, y = Error_softImpute[,1], lty = 3, col = 'green')
lines(x = p_list, y = Error_softImpute[,3], lty = 3, col = 'green')

lines(x = p_list, y = Error_true_Z[,2], col = 'black')
lines(x = p_list, y = Error_true_Z[,1], lty = 3, col = 'black')
lines(x = p_list, y = Error_true_Z[,3], lty = 3, col = 'black')

lines(x = p_list, y = Error_av[,2], col = 'orange')
lines(x = p_list, y = Error_av[,1], lty = 3, col = 'orange')
lines(x = p_list, y = Error_av[,3], lty = 3, col = 'orange')

lines(x = p_list, y = Error_Var[,2], col = 'blue')
lines(x = p_list, y = Error_Var[,1], lty = 3, col = 'blue')
lines(x = p_list, y = Error_Var[,3], lty = 3, col = 'blue')

lines(x = p_list, y = Error_missSBM[,2], col = 'red')
lines(x = p_list, y = Error_missSBM[,1], lty = 3, col = 'red')
lines(x = p_list, y = Error_missSBM[,3], lty = 3, col = 'red')



